/*
 * Decompiled with CFR 0.152.
 */
public enum EnumInsulinResistanceLevel {
    mild("mild", a.o, 48000, true),
    moderate("moderate", a.g, 96000, false),
    severe("severe", a.m, 144000, false);

    private final String unlocalized_name;
    private final a color;
    private final int threshold;
    private final boolean can_metabolize_food_sugars;

    private EnumInsulinResistanceLevel(String unlocalized_name, a color, int threshold, boolean can_metabolize_food_sugars) {
        this.unlocalized_name = unlocalized_name;
        this.color = color;
        this.threshold = threshold;
        this.can_metabolize_food_sugars = can_metabolize_food_sugars;
    }

    static EnumInsulinResistanceLevel get(int ordinal) {
        return EnumInsulinResistanceLevel.values()[ordinal];
    }

    int getOrdinalForTransmission() {
        return this.ordinal() + 1;
    }

    static int getOrdinalForTransmission(EnumInsulinResistanceLevel insulin_resistance_level) {
        return insulin_resistance_level == null ? 0 : insulin_resistance_level.getOrdinalForTransmission();
    }

    static EnumInsulinResistanceLevel getByTransmittedOrdinal(int transmitted_ordinal) {
        return transmitted_ordinal < 1 ? null : EnumInsulinResistanceLevel.values()[transmitted_ordinal - 1];
    }

    boolean isMild() {
        return this == mild;
    }

    boolean isModerate() {
        return this == moderate;
    }

    boolean isSevere() {
        return this == severe;
    }

    String getUnlocalizedName() {
        return this.unlocalized_name;
    }

    a getColor() {
        return this.color;
    }

    float getRedAsFloat() {
        return this.color.getRedAsFloat();
    }

    float getGreenAsFloat() {
        return this.color.getGreenAsFloat();
    }

    float getBlueAsFloat() {
        return this.color.getBlueAsFloat();
    }

    int getThreshold() {
        return this.threshold;
    }

    boolean isLessSevereThan(EnumInsulinResistanceLevel insulin_resistance_level) {
        return insulin_resistance_level != null && insulin_resistance_level.threshold > this.threshold;
    }

    boolean isMoreSevereThan(EnumInsulinResistanceLevel insulin_resistance_level) {
        return insulin_resistance_level == null || insulin_resistance_level.threshold < this.threshold;
    }

    EnumInsulinResistanceLevel getNext() {
        return EnumInsulinResistanceLevel.values()[this.ordinal() + 1];
    }

    static EnumInsulinResistanceLevel getInsulinResistanceLevel(int insulin_resistance) {
        for (int i2 = EnumInsulinResistanceLevel.values().length - 1; i2 >= 0; --i2) {
            if (insulin_resistance < EnumInsulinResistanceLevel.values()[i2].threshold) continue;
            return EnumInsulinResistanceLevel.values()[i2];
        }
        return null;
    }

    boolean canMetabolizeFoodSugars() {
        return this.can_metabolize_food_sugars;
    }
}

